	cpu LMM
	.module main.c
	.area data(ram, con, rel)
_motorEnable::
	.byte 0
	.dbfile ./main.c
	.dbsym e motorEnable _motorEnable c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_slavebufpos::
	.byte 0
	.dbsym e slavebufpos _slavebufpos c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_slavebufchk::
	.byte 0
	.dbsym e slavebufchk _slavebufchk c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_prt2andmask::
	.byte 255
	.dbsym e prt2andmask _prt2andmask c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_prt2ormask::
	.byte 0
	.dbsym e prt2ormask _prt2ormask c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_motorslewcounter::
	.byte 0
	.dbsym e motorslewcounter _motorslewcounter c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogOffsetSampled::
	.byte 0
	.dbsym e analogOffsetSampled _analogOffsetSampled c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_badchars::
	.byte 0
	.dbsym e badchars _badchars c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area text(rom, con, rel)
	.dbfile ./main.c
	.dbfunc e resetState _resetState fV
;              i -> X+0
_resetState::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 97
; //----------------------------------------------------------------------------
; // C main line
; //----------------------------------------------------------------------------
; 
; #include <m8c.h>        // part specific constants and macros
; #include "PSoCAPI.h"    // PSoC API definitions for all User Modules
; #include "util.h"
; #include "ed_slave_int.h"
; #include "error.h"
; #include "qpasm.h"
; 
; #define PINMODE_DIG_IN 			0
; #define PINMODE_DIG_IN_PULLUP   1
; #define PINMODE_DIG_IN_PULLDN   2
; 
; #define PINMODE_DIG_OUT_STRONG  3
; #define PINMODE_DIG_OUT_SLOW    4
; 
; #define PINMODE_SERVO			5
; #define PINMODE_SONAR_PING		6
; #define PINMODE_SONAR_ECHO		7
; 
; #define PINMODE_ANALOG_IN       8
; 
; #define PINMODE_ANALOG_OUT      9
; #define PINMODE_CLOCK_OUT       10
; 
; #define PINMODE_QUADPHASE       11
; #define PINMODE_MONOPHASE       12
; #define PINMODE_MAX             14
; 
; #define PINMODE_QUADPHASEFAST   14
; 
; #define MOTORSLEWPERIOD 4
; 
; //********************************************************
; // GLOBALS
; //******************************************************** 
; unsigned int  analog[8];		// we store all of our analog values here, with 2_1 and 2_2 at 8 and 9.
; unsigned int  analogOffsetError[6]; // track the minimum seen value so we can subtract the error offset.
; 
; unsigned char analogFilter[8];
; short analogNext;	// which port are we sampling?
; short analogDelay;  // how many samples have we skipped since updating our main bank of A/Ds?
; short analogResolution; // how many bits of resolution?
; unsigned char motorEnable=0x00;
; 
; unsigned char pwmGoal[4];
; unsigned char pwmActual[4];
; unsigned char pwmSlew[4];
; unsigned char motorDir[4];
; 
; #define SLAVEBUFSIZE 32 // power of two
; unsigned char slavebuf[SLAVEBUFSIZE];
; unsigned char slavebufpos=0;
; unsigned char slavebufchk=0;
; 
; extern long sleepcounter;
; long lastcounter;
; 
; unsigned char prt2andmask=0xff, prt2ormask=0x00;
; 
; unsigned char pinmode[8];
; 
; unsigned char motorslewcounter=0;
; 
; unsigned char analogOffsetSampled=0;
; 
; unsigned char badchars=0;
; 
; //********************************************************
; // FUNCTION PROTOTYPES
; //******************************************************** 
; void resetState(void);
; void doCommand(void);
; void doSlave(void);
; void doSlaveMessage(void);
; void sendAck(unsigned char flags, unsigned char error);
; void sendPacket(unsigned char flags);
; unsigned char chksend(unsigned char chk, unsigned char c);
; unsigned char chksendi(unsigned char chk, unsigned int c);
; void doSleepCounter(void);
; unsigned char setpinmode(unsigned char pin, unsigned char mode);
; void updateAnalog(void);
; void updateMotor(unsigned char i);
; 
; void updateQp(void);
; 
; extern unsigned int  qpdata0, qpdata1;
; extern unsigned char qperrs0, qperrs1;
; extern unsigned char qpoffset;
; 
; //********************************************************
; // Reset internal state.
; //******************************************************** 
; void resetState()
; {
	.dbline 100
; 	int i;
; 	
; 	for (i=0;i<8;i++)
	mov [X+1],0
	mov [X+0],0
L2:
	.dbline 101
	.dbline 102
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov A,[X+0]
	mov [__r0],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analog
	adc [__r0],>_analog
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	mvi [__r1],A
	.dbline 103
	mov A,[X+1]
	add A,<_analogFilter
	mov [__r1],A
	mov A,[X+0]
	adc A,>_analogFilter
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 104
L3:
	.dbline 100
	inc [X+1]
	adc [X+0],0
	.dbline 100
	mov A,[X+1]
	sub A,8
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L2
X0:
	.dbline 106
; 	{
; 		analog[i]=0;
; 		analogFilter[i]=0;
; 	}
; 	
; 	for (i=0;i<6;i++)
	mov [X+1],0
	mov [X+0],0
L6:
	.dbline 107
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov A,[X+0]
	mov [__r0],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,-1
	mvi [__r1],A
	mvi [__r1],A
L7:
	.dbline 106
	inc [X+1]
	adc [X+0],0
	.dbline 106
	mov A,[X+1]
	sub A,6
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L6
X1:
	.dbline 111
; 		analogOffsetError[i]=65535;
; //	for (i=0;i<6;i++)		// this disables the filter
; //		analogOffsetError[i]=0;
; 
; 	for (i=0;i<4;i++)
	mov [X+1],0
	mov [X+0],0
L10:
	.dbline 112
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,<_analogFilter
	mov [__r1],A
	mov A,[X+0]
	adc A,>_analogFilter
	mov REG[0xd5],A
	mov A,2
	mvi [__r1],A
L11:
	.dbline 111
	inc [X+1]
	adc [X+0],0
	.dbline 111
	mov A,[X+1]
	sub A,4
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L10
X2:
	.dbline 114
; 		analogFilter[i]=2;
; 	
; 	analogFilter[6]=4;
	mov REG[0xd0],>_analogFilter
	mov [_analogFilter+6],4
	.dbline 115
; 	analogFilter[7]=4;
	mov [_analogFilter+7],4
	.dbline 117
; 	
; 	analogNext=0;
	mov REG[0xd0],>_analogNext
	mov [_analogNext+1],0
	mov [_analogNext],0
	.dbline 118
; 	analogDelay=0;
	mov REG[0xd0],>_analogDelay
	mov [_analogDelay+1],0
	mov [_analogDelay],0
	.dbline 119
; 	analogResolution=14;
	mov REG[0xd0],>_analogResolution
	mov [_analogResolution+1],14
	mov [_analogResolution],0
	.dbline 121
; 	
; 	for (i=0;i<4;i++)
	mov [X+1],0
	mov [X+0],0
L16:
	.dbline 122
	.dbline 123
	mov REG[0xd0],>__r0
	mov A,[X+1]
	add A,<_pwmGoal
	mov [__r1],A
	mov A,[X+0]
	adc A,>_pwmGoal
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 124
	mov A,[X+1]
	add A,<_pwmActual
	mov [__r1],A
	mov A,[X+0]
	adc A,>_pwmActual
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 125
	mov A,[X+1]
	add A,<_motorDir
	mov [__r1],A
	mov A,[X+0]
	adc A,>_motorDir
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 126
	mov A,[X+1]
	add A,<_pwmSlew
	mov [__r1],A
	mov A,[X+0]
	adc A,>_pwmSlew
	mov REG[0xd5],A
	mov A,51
	mvi [__r1],A
	.dbline 127
L17:
	.dbline 121
	inc [X+1]
	adc [X+0],0
	.dbline 121
	mov A,[X+1]
	sub A,4
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L16
X3:
	.dbline 129
; 	{
; 		pwmGoal[i]=0;
; 		pwmActual[i]=0;
; 		motorDir[i]=0;
; 		pwmSlew[i]=51;
; 	}
; 	
; 	for (i=0;i<4;i++)
	mov [X+1],0
	mov [X+0],0
L20:
	.dbline 130
	mov A,1
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L21:
	.dbline 129
	inc [X+1]
	adc [X+0],0
	.dbline 129
	mov A,[X+1]
	sub A,4
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L20
X4:
	.dbline 132
; 		setpinmode(i, PINMODE_DIG_IN_PULLUP);
; 
; 	for (i=4;i<8;i++)
	mov [X+1],4
	mov [X+0],0
L24:
	.dbline 133
	mov A,3
	push A
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L25:
	.dbline 132
	inc [X+1]
	adc [X+0],0
	.dbline 132
	mov A,[X+1]
	sub A,8
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L24
X5:
	.dbline -2
	.dbline 134
; 		setpinmode(i, PINMODE_DIG_OUT_STRONG);
; }
L1:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l i 0 I
	.dbend
	.dbfunc e main _main fV
;              v -> X+0
_main::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 137
; 
; void main()
; {
	.dbline 140
; 	unsigned char v;
; 	
; 	PRT2DR=motorEnable; //disable motors (note: HIGH nibble)
	mov REG[0xd0],>_motorEnable
	mov A,[_motorEnable]
	mov REG[0x8],A
	.dbline 142
; 
; 	resetState();
	xcall _resetState
	.dbline 144
; 	
; 	M8C_EnableGInt;
		or  F, 01h

	.dbline 146
; 
; 	PWM8_1_Start();
	push X
	xcall _PWM8_1_Start
	.dbline 147
; 	PWM8_2_Start();
	xcall _PWM8_2_Start
	.dbline 148
; 	PWM8_3_Start();
	xcall _PWM8_3_Start
	.dbline 149
; 	PWM8_4_Start();
	xcall _PWM8_4_Start
	.dbline 151
;  
; 	PWM8_1_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_1_WritePulseWidth
	.dbline 152
; 	PWM8_2_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_2_WritePulseWidth
	.dbline 153
; 	PWM8_3_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_3_WritePulseWidth
	.dbline 154
; 	PWM8_4_WritePulseWidth(0x0);
	mov A,0
	xcall _PWM8_4_WritePulseWidth
	.dbline 156
;  	
;  	PWM8_SLAVECLK_Start();
	xcall _PWM8_SLAVECLK_Start
	.dbline 158
;  	
; 	AMUX4_1_Start();
	xcall _AMUX4_1_Start
	.dbline 159
;  	AMUX4_2_Start();
	xcall _AMUX4_2_Start
	.dbline 160
;  	RefMux_1_Start(RefMux_1_HIGHPOWER);
	mov A,3
	xcall _RefMux_1_Start
	.dbline 162
; 
; 	DelSig_1_Start(DelSig_1_HIGHPOWER);
	mov A,3
	xcall _DelSig_1_Start
	.dbline 163
; 	DelSig_1_StartAD();
	xcall _DelSig_1_StartAD
	.dbline 164
; 	SAR6_1_Start(SAR6_1_FULLPOWER);
	mov A,3
	xcall _SAR6_1_Start
	.dbline 165
; 	SAR6_2_Start(SAR6_2_FULLPOWER);
	mov A,3
	xcall _SAR6_2_Start
	.dbline 167
; 	
;   	ED_SLAVE_init();
	xcall _ED_SLAVE_init
	mov REG[0xd0],>__r0
	pop X
	.dbline 168
;     UART_SLAVE_IntCntl(UART_SLAVE_ENABLE_RX_INT |  UART_SLAVE_ENABLE_TX_INT);
	push X
	mov A,3
	xcall _UART_SLAVE_IntCntl
	.dbline 169
;     UART_SLAVE_Start(UART_SLAVE_PARITY_NONE);
	mov A,0
	xcall _UART_SLAVE_Start
	.dbline 171
; 
; 	QP0A_Start();
	xcall _QP0A_Start
	.dbline 172
; 	QP0B_Start();
	xcall _QP0B_Start
	.dbline 173
; 	QP0INV_Start();
	xcall _QP0INV_Start
	.dbline 174
; 	QP1A_Start();
	xcall _QP1A_Start
	.dbline 175
; 	QP1B_Start();
	xcall _QP1B_Start
	.dbline 176
; 	QP1INV_Start();
	xcall _QP1INV_Start
	pop X
	.dbline 178
; 	
; 	sleepcounter=0;
	mov REG[0xd0],>_sleepcounter
	mov [_sleepcounter],0
	mov [_sleepcounter+1],0
	mov [_sleepcounter+2],0
	mov [_sleepcounter+3],0
	.dbline 179
;  	INT_MSK0|=0x40; // enable sleep interrupts. 512Hz clock.
	or REG[0xe0],64
	xjmp L30
L29:
	.dbline 182
; 		
; 	while (1)
;  	{
	.dbline 183
; 		if (pinmode[0]==PINMODE_QUADPHASEFAST)
	mov REG[0xd0],>_pinmode
	cmp [_pinmode],14
	jnz L32
	.dbline 184
; 			updateQp();
	xcall _updateQp
L32:
	.dbline 186
; 
;  		updateAnalog();
	xcall _updateAnalog
	xjmp L35
L34:
	.dbline 189
	xcall _doSlave
L35:
	.dbline 188
;  			
;   		while (ED_SLAVE_isData())
	push X
	xcall _ED_SLAVE_isData
	pop X
	cmp A,0
	jnz L34
	.dbline 191
;  			doSlave();
;  	
;  		M8C_DisableGInt;
		and F, FEh

	.dbline 192
;  		v = (lastcounter!=sleepcounter);
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter]
	jnz X7
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter+1]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter+1]
	jnz X7
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter+2]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter+2]
	jnz X7
	mov REG[0xd0],>_lastcounter
	mov A,[_lastcounter+3]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter+3]
	jz L38
X7:
	mov [X+2],1
	mov [X+1],0
	xjmp L39
L38:
	mov [X+2],0
	mov [X+1],0
L39:
	mov REG[0xd0],>__r0
	mov A,[X+2]
	mov [X+0],A
	.dbline 193
;  		M8C_EnableGInt;	
		or  F, 01h

	.dbline 194
;  		if (v)
	cmp [X+0],0
	jz L40
	.dbline 195
;  		{
	.dbline 196
;  			doSleepCounter();
	xcall _doSleepCounter
	.dbline 198
;  
;  			M8C_DisableGInt;
		and F, FEh

	.dbline 199
;  			lastcounter=sleepcounter;
	mov REG[0xd0],>_sleepcounter
	mov A,[_sleepcounter]
	push A
	mov A,[_sleepcounter+1]
	push A
	mov A,[_sleepcounter+2]
	push A
	mov A,[_sleepcounter+3]
	mov REG[0xd0],>_lastcounter
	mov [_lastcounter+3],A
	pop A
	mov [_lastcounter+2],A
	pop A
	mov [_lastcounter+1],A
	pop A
	mov [_lastcounter],A
	.dbline 200
;  			M8C_EnableGInt;
		or  F, 01h

	.dbline 202
; 
;  		}
L40:
	.dbline 203
L30:
	.dbline 181
	xjmp L29
X6:
	.dbline -2
	.dbline 204
; 	}
; }
L28:
	add SP,-3
	pop X
	.dbline 0 ; func end
	jmp .
	.dbsym l v 0 c
	.dbend
	.dbfunc e doSleepCounter _doSleepCounter fV
;              i -> X+0
_doSleepCounter::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 207
; 
; void doSleepCounter()
; {
	.dbline 210
; 	unsigned char i;
; 	
; 	motorslewcounter++;
	mov REG[0xd0],>_motorslewcounter
	inc [_motorslewcounter]
	.dbline 211
; 	if (motorslewcounter<MOTORSLEWPERIOD)
	cmp [_motorslewcounter],4
	jnc L43
X8:
	.dbline 212
; 		return;
	xjmp L42
L43:
	.dbline 213
; 	motorslewcounter=0;
	mov REG[0xd0],>_motorslewcounter
	mov [_motorslewcounter],0
	.dbline 215
; 	
; 	for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L48
L45:
	.dbline 216
	.dbline 217
	mov A,[X+0]
	push A
	xcall _updateMotor
	add SP,-1
	.dbline 218
L46:
	.dbline 215
	inc [X+0]
L48:
	.dbline 215
	cmp [X+0],4
	jc L45
X9:
	.dbline -2
	.dbline 219
; 	{
; 		updateMotor(i);
; 	}
; }
L42:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l i 0 c
	.dbend
	.dbfunc e updateMotor _updateMotor fV
;           mode -> X+4
;      actualdir -> X+3
;        goaldir -> X+2
;              v -> X+0
;              i -> X-4
_updateMotor::
	.dbline -1
	push X
	mov X,SP
	add SP,7
	.dbline 222
; 
; void updateMotor(unsigned char i)
; {
	.dbline 226
; 	unsigned char actualdir, goaldir, mode;
; 	int v;
; 	
; 	goaldir=motorDir[i]&3;
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	and A,3
	mov [X+2],A
	.dbline 227
; 	actualdir=(motorDir[i]>>2)&3;
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	asr [__r0]
	asr [__r0]
	and [__r0],63
	mov A,[__r0]
	and A,3
	mov [X+3],A
	.dbline 229
; 		
; 	if (goaldir==0) // do nothing if we're disabled.
	cmp [X+2],0
	jnz L50
	.dbline 230
; 		return;
	xjmp L49
L50:
	.dbline 233
; 			
; 	// now, compute our new PWM value
; 	v=pwmActual[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	mov [X+0],0
	.dbline 235
; 		
; 	if (goaldir==actualdir)
	mov A,[X+2]
	cmp A,[X+3]
	jnz L52
	.dbline 236
; 	{
	.dbline 238
; 		// we're already going in the right direction; make pwmactual follow pwmgoal
; 		if (v<pwmGoal[i])
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+1]
	sub A,[__r1]
	mov A,0
	xor A,-128
	mov [__rX],A
	mov A,[X+0]
	xor A,-128
	sbb A,[__rX]
	jnc L54
X12:
	.dbline 239
; 			{
	.dbline 240
; 			v=v+pwmSlew[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],0
	add [X+1],A
	adc [X+0],0
	.dbline 241
; 			if (v>pwmGoal[i])
	mov A,[X-4]
	mov [__r1],A
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	sub A,[X+1]
	mov A,[X+0]
	xor A,-128
	mov [__rX],A
	mov A,0
	xor A,-128
	sbb A,[__rX]
	jnc L56
X13:
	.dbline 242
; 				v=pwmGoal[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	mov [X+0],0
L56:
	.dbline 243
; 			}
L54:
	.dbline 245
; 			
; 		if (v>pwmGoal[i])
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	sub A,[X+1]
	mov A,[X+0]
	xor A,-128
	mov [__rX],A
	mov A,0
	xor A,-128
	sbb A,[__rX]
	jnc L53
X14:
	.dbline 246
; 			{
	.dbline 247
; 			v=v-pwmSlew[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],0
	sub [X+1],A
	sbb [X+0],0
	.dbline 248
; 			if (v<pwmGoal[i])
	mov A,[X-4]
	mov [__r1],A
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+1]
	sub A,[__r1]
	mov A,0
	xor A,-128
	mov [__rX],A
	mov A,[X+0]
	xor A,-128
	sbb A,[__rX]
	jnc L53
X15:
	.dbline 249
; 				v=pwmGoal[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	mov [X+0],0
	.dbline 250
; 			}
	.dbline 251
; 	}
	xjmp L53
L52:
	.dbline 253
; 	else
; 	{
	.dbline 255
; 		// we're going the wrong way. Slow down!
; 		v=v-pwmSlew[i];
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	sub [X+1],A
	sbb [X+0],0
	.dbline 256
; 		if (v<0)
	mov A,[X+1]
	sub A,0
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jnc L62
X16:
	.dbline 257
; 			v=0;
	mov [X+1],0
	mov [X+0],0
L62:
	.dbline 259
; 			
; 		if (v==0) // if we've slowed down all the way, we can change direction.
	cmp [X+0],0
	jnz L64
	cmp [X+1],0
	jnz L64
X17:
	.dbline 260
; 		{
	.dbline 263
; 			// we've reached zero speed. set the new direction.
; 			
; 			if (goaldir==1)
	cmp [X+2],1
	jnz L66
	.dbline 264
; 				mode=0x05;
	mov [X+4],5
	xjmp L67
L66:
	.dbline 266
; 			else
; 				mode=0x30;
	mov [X+4],48
L67:
	.dbline 269
; 				
; 			// change the direction...
; 			switch (i)
	mov A,[X-4]
	mov [X+6],A
	mov [X+5],0
	cmp [X+5],0
	jnz X18
	cmp [X+6],0
	jz L71
X18:
	cmp [X+5],0
	jnz X19
	cmp [X+6],1
	jz L72
X19:
	cmp [X+5],0
	jnz X20
	cmp [X+6],2
	jz L73
X20:
	cmp [X+5],0
	jnz X21
	cmp [X+6],3
	jz L74
X21:
	xjmp L68
X10:
	.dbline 270
; 				{
L71:
	.dbline 272
; 				case 0:
; 					RDI1LT0=mode;
	mov A,[X+4]
	mov REG[0xbb],A
	.dbline 273
; 					break;
	xjmp L69
L72:
	.dbline 275
; 				case 1:
; 					RDI1LT1=mode;
	mov A,[X+4]
	mov REG[0xbc],A
	.dbline 276
; 					break;
	xjmp L69
L73:
	.dbline 278
; 				case 2:
; 					RDI2LT0=mode;
	mov A,[X+4]
	mov REG[0xc3],A
	.dbline 279
; 					break;
	xjmp L69
L74:
	.dbline 281
; 				case 3:
; 					RDI2LT1=mode;
	mov A,[X+4]
	mov REG[0xc4],A
	.dbline 282
; 					break;
L68:
L69:
	.dbline 285
; 				}
; 
; 			motorDir[i]=(goaldir<<2)|goaldir;
	mov A,[X+2]
	mov REG[0xd0],>__r0
	mov [__r0],A
	asl [__r0]
	asl [__r0]
	mov A,[X+2]
	or [__r0],A
	mov A,[X-4]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_motorDir
	adc [__r2],>_motorDir
	mov A,[__r2]
	mov REG[0xd5],A
	mov A,[__r0]
	mvi [__r3],A
	.dbline 286
; 		}
L64:
	.dbline 287
; 	}
L53:
	.dbline 290
; 		
; 	// write the new pwm value
; 	pwmActual[i]=v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r0],A
	mov A,[X-4]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_pwmActual
	adc [__r2],>_pwmActual
	mov A,[__r2]
	mov REG[0xd5],A
	mov A,[__r0]
	mvi [__r3],A
	.dbline 292
; 		
; 	switch (i)
	mov A,[X-4]
	mov [X+6],A
	mov [X+5],0
	cmp [X+5],0
	jnz X22
	cmp [X+6],0
	jz L78
X22:
	cmp [X+5],0
	jnz X23
	cmp [X+6],1
	jz L79
X23:
	cmp [X+5],0
	jnz X24
	cmp [X+6],2
	jz L80
X24:
	cmp [X+5],0
	jnz X25
	cmp [X+6],3
	jz L81
X25:
	xjmp L75
X11:
	.dbline 293
; 		{
L78:
	.dbline 295
; 		case 0:
; 			PWM8_1_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_1_WritePulseWidth
	pop X
	.dbline 296
; 			break;
	xjmp L76
L79:
	.dbline 298
; 		case 1:
; 			PWM8_2_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_2_WritePulseWidth
	pop X
	.dbline 299
; 			break;
	xjmp L76
L80:
	.dbline 301
; 		case 2:
; 			PWM8_3_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_3_WritePulseWidth
	pop X
	.dbline 302
; 			break;
	xjmp L76
L81:
	.dbline 304
; 		case 3:
; 			PWM8_4_WritePulseWidth(v);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	push X
	xcall _PWM8_4_WritePulseWidth
	pop X
	.dbline 305
; 			break;						
L75:
L76:
	.dbline -2
	.dbline 307
; 		}	
; }
L49:
	add SP,-7
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l mode 4 c
	.dbsym l actualdir 3 c
	.dbsym l goaldir 2 c
	.dbsym l v 0 I
	.dbsym l i -4 c
	.dbend
	.dbfunc e doSlave _doSlave fV
;              c -> X+0
_doSlave::
	.dbline -1
	push X
	mov X,SP
	add SP,3
	.dbline 310
; 
; void doSlave(void)
; {
	.dbline 311
; 	char c=ED_SLAVE_getData();
	push X
	xcall _ED_SLAVE_getData
	pop X
	mov [X+0],A
	.dbline 314
; 	
; 	// wait for header
; 	if (slavebufpos==0 && c!=237)
	mov REG[0xd0],>_slavebufpos
	cmp [_slavebufpos],0
	jnz L83
	cmp [X+0],-19
	jz L83
	.dbline 315
; 	{
	.dbline 316
; 		badchars++;
	mov REG[0xd0],>_badchars
	inc [_badchars]
	.dbline 317
; 		return;
	xjmp L82
L83:
	.dbline 320
; 	}
; 	
; 	slavebuf[slavebufpos++]=c;
	mov REG[0xd0],>_slavebufpos
	mov A,[_slavebufpos]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	add A,1
	mov REG[0xd0],>_slavebufpos
	mov [_slavebufpos],A
	mov REG[0xd0],>__r0
	add [__r1],<_slavebuf
	adc [__r0],>_slavebuf
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+0]
	mvi [__r1],A
	.dbline 322
; 	
; 	if (slavebufpos<2 || slavebufpos<slavebuf[1])
	mov REG[0xd0],>_slavebufpos
	cmp [_slavebufpos],2
	jc L88
X26:
	mov REG[0xd0],>_slavebufpos
	mov A,[_slavebufpos]
	mov REG[0xd0],>_slavebuf
	cmp A,[_slavebuf+1]
	jnc L85
X27:
L88:
	.dbline 323
; 		slavebufchk=(slavebufchk<<1) + c + (slavebufchk&0x80 ? 1 : 0);
	mov REG[0xd0],>_slavebufchk
	tst [_slavebufchk],-128
	jz L90
	mov [X+2],1
	mov [X+1],0
	xjmp L91
L90:
	mov [X+2],0
	mov [X+1],0
L91:
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov REG[0xd0],>_slavebufchk
	mov A,[_slavebufchk]
	mov REG[0xd0],>__r0
	mov [__r3],A
	asl [__r3]
	mov A,[__r3]
	add A,[__r1]
	mov [__r1],A
	mov A,[X+2]
	add [__r1],A
	mov A,[__r1]
	mov REG[0xd0],>_slavebufchk
	mov [_slavebufchk],A
L85:
	.dbline 326
; 		
; 	// if we're too long, quit!
; 	if (slavebufpos>=SLAVEBUFSIZE)
	mov REG[0xd0],>_slavebufpos
	cmp [_slavebufpos],32
	jc L92
X28:
	.dbline 327
; 		{
	.dbline 328
; 		slavebufpos=0;
	mov REG[0xd0],>_slavebufpos
	mov [_slavebufpos],0
	.dbline 329
; 		slavebufchk=0;
	mov REG[0xd0],>_slavebufchk
	mov [_slavebufchk],0
	.dbline 330
; 		return;
	xjmp L82
L92:
	.dbline 334
; 		}
; 	
; 	// wait for rest of packet. 
; 	if (slavebuf[1]!=slavebufpos)
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+1]
	mov REG[0xd0],>_slavebufpos
	cmp A,[_slavebufpos]
	jz L94
	.dbline 335
; 		return;
	xjmp L82
L94:
	.dbline 337
; 	
; 	if (slavebufchk==slavebuf[slavebufpos-1])
	mov REG[0xd0],>_slavebufpos
	mov A,[_slavebufpos]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_slavebuf-1
	adc [__r0],>_slavebuf-1
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mov REG[0xd0],>_slavebufchk
	mov A,[_slavebufchk]
	mov REG[0xd0],>__r0
	cmp A,[__r0]
	jnz L97
	.dbline 338
; 		doSlaveMessage();
	xcall _doSlaveMessage
	xjmp L98
L97:
	.dbline 340
; 	else
; 		badchars+=slavebuf[1];
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+1]
	mov REG[0xd0],>_badchars
	add [_badchars],A
L98:
	.dbline 343
; 		
; 	// handle the packet
; 	slavebufpos=0;
	mov REG[0xd0],>_slavebufpos
	mov [_slavebufpos],0
	.dbline 344
; 	slavebufchk=0;
	mov REG[0xd0],>_slavebufchk
	mov [_slavebufchk],0
	.dbline -2
	.dbline 345
; }
L82:
	add SP,-3
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c 0 c
	.dbend
	.dbfunc e updateAnalog _updateAnalog fV
;              v -> X+0
_updateAnalog::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 348
; 
; void updateAnalog(void)
; {
	.dbline 351
; 	unsigned int v;
; 
; 	v=(SAR6_2_cGetSample()<<10)+0x8000;
	push X
	xcall _SAR6_2_cGetSample
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	tst [__r1],-128
	jz X29
X29:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov [__r0],A
	mov [__r1],0
	asl [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	add A,0
	mov [X+1],A
	mov A,[__r0]
	adc A,-128
	mov [X+0],A
	.dbline 352
; 	analog[6]=analog[6]-(analog[6]>>analogFilter[6])+(v>>analogFilter[6]);
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+6]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov A,[X+1]
	mov [__r3],A
	mov A,[X+0]
	mov [__r2],A
	mov A,[__r1]
	and A,15
	jz X30
X31:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r2]
	rrc [__r3]
	dec A
	jnz X31
X30:
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+6]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_analog
	mov A,[_analog+12+1]
	push A
	mov A,[_analog+12]
	mov REG[0xd0],>__r0
	mov [__r4],A
	pop A
	mov [__r5],A
	mov A,[__r1]
	and A,15
	jz X32
X33:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r4]
	rrc [__r5]
	dec A
	jnz X33
X32:
	mov REG[0xd0],>_analog
	mov A,[_analog+12+1]
	mov REG[0xd0],>__r0
	sub A,[__r5]
	mov [__r1],A
	mov REG[0xd0],>_analog
	mov A,[_analog+12]
	mov REG[0xd0],>__r0
	sbb A,[__r4]
	mov [__r0],A
	mov A,[__r1]
	add A,[__r3]
	mov REG[0xd0],>_analog
	mov [_analog+12+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	adc A,[__r2]
	mov REG[0xd0],>_analog
	mov [_analog+12],A
	.dbline 354
; 
; 	v=(SAR6_1_cGetSample()<<10)+0x8000;	
	push X
	xcall _SAR6_1_cGetSample
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	tst [__r1],-128
	jz X34
X34:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov [__r0],A
	mov [__r1],0
	asl [__r0]
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	add A,0
	mov [X+1],A
	mov A,[__r0]
	adc A,-128
	mov [X+0],A
	.dbline 355
; 	analog[7]=analog[7]-(analog[7]>>analogFilter[7])+(v>>analogFilter[7]);
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+7]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov A,[X+1]
	mov [__r3],A
	mov A,[X+0]
	mov [__r2],A
	mov A,[__r1]
	and A,15
	jz X35
X36:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r2]
	rrc [__r3]
	dec A
	jnz X36
X35:
	mov REG[0xd0],>_analogFilter
	mov A,[_analogFilter+7]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_analog
	mov A,[_analog+14+1]
	push A
	mov A,[_analog+14]
	mov REG[0xd0],>__r0
	mov [__r4],A
	pop A
	mov [__r5],A
	mov A,[__r1]
	and A,15
	jz X37
X38:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r4]
	rrc [__r5]
	dec A
	jnz X38
X37:
	mov REG[0xd0],>_analog
	mov A,[_analog+14+1]
	mov REG[0xd0],>__r0
	sub A,[__r5]
	mov [__r1],A
	mov REG[0xd0],>_analog
	mov A,[_analog+14]
	mov REG[0xd0],>__r0
	sbb A,[__r4]
	mov [__r0],A
	mov A,[__r1]
	add A,[__r3]
	mov REG[0xd0],>_analog
	mov [_analog+14+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	adc A,[__r2]
	mov REG[0xd0],>_analog
	mov [_analog+14],A
	.dbline 357
; 
; 	if (!DelSig_1_fIsDataAvailable())
	push X
	xcall _DelSig_1_fIsDataAvailable
	mov REG[0xd0],>__r0
	pop X
	cmp A,0
	jnz L112
	.dbline 358
; 		return;
	xjmp L101
L112:
	.dbline 360
; 
; 	v=DelSig_1_iGetDataClearFlag();
	push X
	xcall _DelSig_1_iGetDataClearFlag
	mov REG[0xd0],>__r0
	mov [__r0],X
	pop X
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 362
; 
; 	analogDelay++;			// since the A/D is pipelined, we must throw out 2 samples after changing the mux.
	mov REG[0xd0],>_analogDelay
	inc [_analogDelay+1]
	adc [_analogDelay],0
	.dbline 363
; 	if (analogDelay>=3)
	mov A,[_analogDelay+1]
	sub A,3
	mov A,[_analogDelay]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L114
X39:
	.dbline 364
; 	{
	.dbline 365
; 		v=v<<2; // left align
	asl [X+1]
	rlc [X+0]
	asl [X+1]
	rlc [X+0]
	.dbline 367
; 		
; 		analogDelay=0;
	mov REG[0xd0],>_analogDelay
	mov [_analogDelay+1],0
	mov [_analogDelay],0
	.dbline 369
; 		
; 		analog[analogNext]=analog[analogNext]-(analog[analogNext]>>analogFilter[analogNext])+(v>>analogFilter[analogNext]);
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analog
	adc [__r0],>_analog
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r2],A
	mvi A,[__r1]
	sub [__r1],2
	mov [__r3],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	add A,<_analogFilter
	mov REG[0xd0],>__r0
	mov [__r5],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext]
	adc A,>_analogFilter
	mov REG[0xd0],>__r0
	mov REG[0xd4],A
	mvi A,[__r5]
	mov [__r5],A
	mov A,[X+1]
	mov [__r7],A
	mov A,[X+0]
	mov [__r6],A
	mov A,[__r5]
	and A,15
	jz X40
X41:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r6]
	rrc [__r7]
	dec A
	jnz X41
X40:
	mov REG[0xd0],>__r0
	mov A,[__r3]
	push A
	mov A,[__r2]
	mov [__r8],A
	pop A
	mov [__r9],A
	mov A,[__r5]
	and A,15
	jz X42
X43:
	and F,-5
	mov REG[0xd0],>__r0
	rrc [__r8]
	rrc [__r9]
	dec A
	jnz X43
X42:
	mov REG[0xd0],>__r0
	mov A,[__r9]
	sub [__r3],A
	mov A,[__r8]
	sbb [__r2],A
	mov A,[__r7]
	add [__r3],A
	mov A,[__r6]
	adc [__r2],A
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[__r2]
	mvi [__r1],A
	mov A,[__r3]
	mvi [__r1],A
	.dbline 371
; 		
; 		if (v<analogOffsetError[analogNext])
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[X+1]
	sub A,[__r1]
	mov A,[X+0]
	sbb A,[__r0]
	jnc L116
X44:
	.dbline 372
; 			analogOffsetError[analogNext]=v;
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asl [__r1]
	rlc [__r0]
	add [__r1],<_analogOffsetError
	adc [__r0],>_analogOffsetError
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+0]
	mvi [__r1],A
	mov A,[X+1]
	mvi [__r1],A
L116:
	.dbline 375
; 			
; 		// rotate the port
; 		analogNext=(analogNext+1)&7;
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	add A,1
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext]
	adc A,0
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[__r1]
	and A,7
	mov REG[0xd0],>_analogNext
	mov [_analogNext+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	and A,0
	mov REG[0xd0],>_analogNext
	mov [_analogNext],A
	.dbline 376
; 		if (analogNext>=6)
	mov A,[_analogNext+1]
	sub A,6
	mov A,[_analogNext]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jc L118
X45:
	.dbline 377
; 			analogNext=0;
	mov REG[0xd0],>_analogNext
	mov [_analogNext+1],0
	mov [_analogNext],0
L118:
	.dbline 379
; 			
; 		AMUX4_1_InputSelect(analogNext>>1);
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asr [__r0]
	rrc [__r1]
	mov A,[__r1]
	push X
	xcall _AMUX4_1_InputSelect
	pop X
	.dbline 380
; 		AMUX4_2_InputSelect(analogNext>>1);
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	push A
	mov A,[_analogNext]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov [__r1],A
	asr [__r0]
	rrc [__r1]
	mov A,[__r1]
	push X
	xcall _AMUX4_2_InputSelect
	pop X
	.dbline 382
; 		
; 		if (analogNext&1)
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext+1]
	and A,1
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_analogNext
	mov A,[_analogNext]
	and A,0
	mov REG[0xd0],>__r0
	cmp A,0
	jnz X46
	cmp [__r1],0
	jz L120
X46:
	.dbline 383
; 			ABF_CR0=ABF_CR0|0x80;
	or F,0x10  ; iopage = 1
	or REG[0x62],-128
	and F,0xEF ; iopage = 0
	xjmp L121
L120:
	.dbline 385
; 		else
; 			ABF_CR0=ABF_CR0&0x7f;
	or F,0x10  ; iopage = 1
	and REG[0x62],127
	and F,0xEF ; iopage = 0
L121:
	.dbline 386
L114:
	.dbline -2
	.dbline 388
; 	}
; 	
; }
L101:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v 0 i
	.dbend
	.dbfunc e doSlaveMessage _doSlaveMessage fV
;           mask -> X+6
;            err -> X+5
;            dir -> X+4
;            len -> X+3
;              v -> X+2
;           port -> X+1
;              i -> X+0
_doSlaveMessage::
	.dbline -1
	push X
	mov X,SP
	add SP,7
	.dbline 394
; 
; 
; #define OFFSET 3
; 
; void doSlaveMessage()
; {
	.dbline 396
; 	unsigned char port, v, dir, i, mask;
; 	unsigned char len=slavebuf[1]-4;
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+1]
	sub A,4
	mov [X+3],A
	.dbline 399
; 	unsigned char err;
; 
; 	if (slavebuf[OFFSET]=='*' && len==1)
	cmp [_slavebuf+3],42
	jnz L124
	cmp [X+3],1
	jnz L124
	.dbline 400
; 	{
	.dbline 401
; 		sendPacket(slavebuf[2]);
	mov A,[_slavebuf+2]
	push A
	xcall _sendPacket
	add SP,-1
	.dbline 402
; 		return;
	xjmp L122
L124:
	.dbline 406
; 	}
; 
; 	// pwm slew: Wps
; 	if (slavebuf[OFFSET]=='W' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],87
	jnz L128
	cmp [X+3],3
	jnz L128
	.dbline 407
; 	{
	.dbline 408
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 409
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 411
; 
; 		if (port>3)
	mov A,3
	cmp A,[X+1]
	jnc L133
X47:
	.dbline 412
; 		{
	.dbline 413
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 414
; 			return;
	xjmp L122
L133:
	.dbline 417
; 		}
; 			
; 		pwmSlew[port]=v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+2]
	mvi [__r1],A
	.dbline 418
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 419
; 		return;
	xjmp L122
L128:
	.dbline 423
; 		
; 	}
; 	
; 	if (slavebuf[OFFSET]=='F' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],70
	jnz L137
	cmp [X+3],3
	jnz L137
	.dbline 424
; 	{
	.dbline 425
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 426
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 428
; 
; 		if (port>7)
	mov A,7
	cmp A,[X+1]
	jnc L142
X48:
	.dbline 429
; 		{
	.dbline 430
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 431
; 			return;
	xjmp L122
L142:
	.dbline 433
; 		}
; 		if (v>15)
	mov A,15
	cmp A,[X+2]
	jnc L145
X49:
	.dbline 434
; 		{
	.dbline 435
; 			sendAck(slavebuf[2], EBADPARAM);
	mov A,2
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 436
; 			return;
	xjmp L122
L145:
	.dbline 439
; 		}
; 			
; 		analogFilter[port]=v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_analogFilter
	adc [__r0],>_analogFilter
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+2]
	mvi [__r1],A
	.dbline 440
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 441
; 		return;
	xjmp L122
L137:
	.dbline 445
; 	}
; 	
; 	// digital write: Dpv
; 	if (slavebuf[OFFSET]=='D' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],68
	jnz L149
	cmp [X+3],3
	jnz L149
	.dbline 446
; 	{
	.dbline 447
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 448
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 449
; 		if (port>3 || v>1)
	mov A,3
	cmp A,[X+1]
	jc L156
X50:
	mov A,1
	cmp A,[X+2]
	jnc L154
X51:
L156:
	.dbline 450
; 		{
	.dbline 451
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 452
; 			return;
	xjmp L122
L154:
	.dbline 455
; 		}
; 		
; 		if (v>1)
	mov A,1
	cmp A,[X+2]
	jnc L158
X52:
	.dbline 456
; 		{
	.dbline 457
; 			sendAck(slavebuf[2], EBADPARAM);
	mov A,2
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 458
; 			return;
	xjmp L122
L158:
	.dbline 461
; 		}
; 		
; 		if (v)
	cmp [X+2],0
	jz L161
	.dbline 462
; 			v=0xff;
	mov [X+2],-1
L161:
	.dbline 464
; 			
; 		port=1<<port;
	mov REG[0xd0],>__r0
	mov [__r0],1
	mov A,[X+1]
	and A,7
	jz X53
X54:
	mov REG[0xd0],>__r0
	asl [__r0]
	dec A
	jnz X54
X53:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov [X+1],A
	.dbline 466
; 
; 		PRT2DR=(PRT2DR&prt2andmask&(~port))|prt2ormask|(v&port);
	mov A,[X+2]
	and A,[X+1]
	mov [__r0],A
	mov A,[X+1]
	cpl A
	mov [__r2],A
	mov A,REG[0x8]
	mov [__r4],A
	mov REG[0xd0],>_prt2andmask
	mov A,[_prt2andmask]
	mov REG[0xd0],>__r0
	and [__r4],A
	mov A,[__r4]
	and A,[__r2]
	mov [__r2],A
	mov REG[0xd0],>_prt2ormask
	mov A,[_prt2ormask]
	mov REG[0xd0],>__r0
	or [__r2],A
	mov A,[__r2]
	or A,[__r0]
	mov REG[0x8],A
	.dbline 468
; 		
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 469
; 		return;
	xjmp L122
L149:
	.dbline 473
; 	}
; 	
; 	// set mode:   Cpm
; 	if (slavebuf[OFFSET]=='C' && len==3)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],67
	jnz L164
	cmp [X+3],3
	jnz L164
	.dbline 474
; 	{
	.dbline 475
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 476
; 		v=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+2],A
	.dbline 477
; 		err=setpinmode(port, v);
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _setpinmode
	add SP,-2
	mov [X+5],A
	.dbline 479
; 
; 		if (err)
	cmp [X+5],0
	jz L169
	.dbline 480
; 		{
	.dbline 481
; 			sendAck(slavebuf[2], err);
	mov A,[X+5]
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 482
; 			return;		
	xjmp L122
L169:
	.dbline 485
; 		}
; 		
; 		if (v==PINMODE_QUADPHASE)
	cmp [X+2],11
	jnz L172
	.dbline 486
; 		{
	.dbline 487
; 			for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L177
L174:
	.dbline 488
	mov A,11
	push A
	mov A,[X+0]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L175:
	.dbline 487
	inc [X+0]
L177:
	.dbline 487
	cmp [X+0],4
	jc L174
X55:
	.dbline 490
; 				setpinmode(i, PINMODE_QUADPHASE);	
; 			
; 			qpoffset=0x00;  // quadrature phase
	mov REG[0xd0],>_qpoffset
	mov [_qpoffset],0
	.dbline 491
; 			M8C_EnableIntMask(INT_MSK0, INT_MSK0_GPIO);		
	or REG[0xe0],32
	.dbline 492
; 		}
	xjmp L173
L172:
	.dbline 493
; 		else if (v==PINMODE_MONOPHASE)
	cmp [X+2],12
	jnz L178
	.dbline 494
; 		{
	.dbline 495
; 			setpinmode(0, PINMODE_MONOPHASE);
	mov A,12
	push A
	mov A,0
	push A
	xcall _setpinmode
	mov REG[0xd0],>__r0
	.dbline 496
; 			setpinmode(1, PINMODE_DIG_IN_PULLUP);
	mov A,1
	push A
	push A
	xcall _setpinmode
	add SP,-4
	mov REG[0xd0],>__r0
	.dbline 497
; 			setpinmode(2, PINMODE_MONOPHASE);
	mov A,12
	push A
	mov A,2
	push A
	xcall _setpinmode
	mov REG[0xd0],>__r0
	.dbline 498
; 			setpinmode(3, PINMODE_DIG_IN_PULLUP);		
	mov A,1
	push A
	mov A,3
	push A
	xcall _setpinmode
	add SP,-4
	.dbline 499
; 			qpoffset=0x10;  // mono phase
	mov REG[0xd0],>_qpoffset
	mov [_qpoffset],16
	.dbline 500
; 			M8C_EnableIntMask(INT_MSK0, INT_MSK0_GPIO);		
	or REG[0xe0],32
	.dbline 501
; 		}
	xjmp L179
L178:
	.dbline 502
; 		else if (v==PINMODE_QUADPHASEFAST)
	cmp [X+2],14
	jnz L180
	.dbline 503
; 		{
	.dbline 504
; 			M8C_DisableIntMask(INT_MSK0, INT_MSK0_GPIO);		
	and REG[0xe0],-33
	.dbline 506
; 
; 			for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L185
L182:
	.dbline 507
	mov A,14
	push A
	mov A,[X+0]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
L183:
	.dbline 506
	inc [X+0]
L185:
	.dbline 506
	cmp [X+0],4
	jc L182
X56:
	.dbline 508
; 				setpinmode(i, PINMODE_QUADPHASEFAST);	
; 		}
	xjmp L181
L180:
	.dbline 510
; 		else
; 		{
	.dbline 511
; 			for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L189
L186:
	.dbline 512
; 			{
	.dbline 513
; 				if (pinmode[i]==PINMODE_QUADPHASE || pinmode[i]==PINMODE_MONOPHASE || pinmode[i]==PINMODE_QUADPHASEFAST)
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pinmode
	adc [__r0],>_pinmode
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r1],A
	mov [__r0],0
	cmp [__r0],0
	jnz X57
	cmp A,11
	jz L193
X57:
	mov REG[0xd0],>__r0
	cmp [__r0],0
	jnz X58
	cmp [__r1],12
	jz L193
X58:
	mov REG[0xd0],>__r0
	cmp [__r0],0
	jnz L190
	cmp [__r1],14
	jnz L190
X59:
L193:
	.dbline 514
; 				{
	.dbline 515
; 					setpinmode(i, PINMODE_DIG_IN_PULLUP);	
	mov A,1
	push A
	mov A,[X+0]
	push A
	xcall _setpinmode
	add SP,-2
	mov REG[0xd0],>__r0
	.dbline 516
; 				}
L190:
	.dbline 517
L187:
	.dbline 511
	inc [X+0]
L189:
	.dbline 511
	cmp [X+0],4
	jc L186
X60:
	.dbline 518
; 			}						
; 		}
L181:
L179:
L173:
	.dbline 520
; 								
; 		sendAck(slavebuf[2], err);
	mov A,[X+5]
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 521
; 		return;		
	xjmp L122
L164:
	.dbline 527
; 	}
; 
; 	// Motor: Mpdv  [port, direction, pwm value]
; 	// direction, [0,1,2] (0=disabled, 1=forw, 2=back. Braking occurs with either forw/back 
; 	// when pwm is small. When disabled, pwm is ignored. (this disables slewing))
; 	if (slavebuf[OFFSET]=='M' && len==4)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],77
	jnz L195
	cmp [X+3],4
	jnz L195
	.dbline 528
; 	{
	.dbline 529
; 		port=slavebuf[OFFSET+1];
	mov A,[_slavebuf+4]
	mov [X+1],A
	.dbline 530
; 		dir=slavebuf[OFFSET+2];
	mov A,[_slavebuf+5]
	mov [X+4],A
	.dbline 531
; 		v=slavebuf[OFFSET+3];
	mov A,[_slavebuf+6]
	mov [X+2],A
	.dbline 533
; 
; 		if (port>3)
	mov A,3
	cmp A,[X+1]
	jnc L201
X61:
	.dbline 534
; 		{
	.dbline 535
; 			sendAck(slavebuf[2], EBADPORT);
	mov A,1
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 536
; 			return;
	xjmp L122
L201:
	.dbline 539
; 		}
; 		
; 		if (dir>2)
	mov A,2
	cmp A,[X+4]
	jnc L204
X62:
	.dbline 540
; 		{
	.dbline 541
; 			sendAck(slavebuf[2], EBADPARAM);
	mov A,2
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 542
; 			return;
	xjmp L122
L204:
	.dbline 547
; 		}
; 
; 		// due to routing issues, motor ports 1 and 3 are wired up
; 		// backwards. So we reverse the direction of odd motors below.
; 		if (dir>0 && (dir&1))
	mov A,0
	cmp A,[X+4]
	jnc L207
X63:
	tst [X+4],1
	jz L207
	.dbline 548
; 		{
	.dbline 549
; 			dir=2-dir;
	mov REG[0xd0],>__r0
	mov A,2
	sub A,[X+4]
	mov [X+4],A
	.dbline 550
; 		}
L207:
	.dbline 552
; 		
; 		motorDir[port]=(motorDir[port]&0x0c)|dir;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	dec [__r1]
	mov [__r2],A
	and [__r2],12
	mov A,[X+4]
	or [__r2],A
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[__r2]
	mvi [__r1],A
	.dbline 553
; 		pwmGoal[port]=v;
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X+2]
	mvi [__r1],A
	.dbline 558
; 		
; 		// if they're disabling the motor, *really* shut it down
; 		// and set actual to zero so they don't accidentally start
; 		// it back up too fast.
; 		mask=(1<<port)<<4; // convert the port to a mask.
	mov [__r0],1
	mov A,[X+1]
	and A,7
	jz X64
X65:
	mov REG[0xd0],>__r0
	asl [__r0]
	dec A
	jnz X65
X64:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	asl A
	asl A
	asl A
	asl A
	mov [X+6],A
	.dbline 559
; 		if (dir==0)
	cmp [X+4],0
	jnz L209
	.dbline 560
; 		{
	.dbline 561
; 			pwmActual[port]=0;
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 562
; 			pwmGoal[port]=0;
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 564
; 
; 			motorEnable&=(~mask);
	mov A,[X+6]
	cpl A
	mov REG[0xd0],>_motorEnable
	and [_motorEnable],A
	.dbline 565
; 		}
	xjmp L210
L209:
	.dbline 567
; 		else
; 		{
	.dbline 568
; 			motorEnable|=mask;	
	mov REG[0xd0],>_motorEnable
	mov A,[_motorEnable]
	or A,[X+6]
	mov [_motorEnable],A
	.dbline 569
; 		}
L210:
	.dbline 571
; 
; 		PRT2DR=(PRT2DR&0x0f)|motorEnable;
	mov A,REG[0x8]
	mov REG[0xd0],>__r0
	mov [__r0],A
	and [__r0],15
	mov REG[0xd0],>_motorEnable
	mov A,[_motorEnable]
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[__r0]
	mov REG[0x8],A
	.dbline 573
; 		
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 574
; 		return;
	xjmp L122
L195:
	.dbline 578
; 	}
; 	
; 	// all stop! Set PWM goal to zero.
; 	if (slavebuf[OFFSET]=='X' && len==1)
	mov REG[0xd0],>_slavebuf
	cmp [_slavebuf+3],88
	jnz L212
	cmp [X+3],1
	jnz L212
	.dbline 579
; 	{
	.dbline 580
; 		for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L218
L215:
	.dbline 581
	.dbline 582
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 583
L216:
	.dbline 580
	inc [X+0]
L218:
	.dbline 580
	cmp [X+0],4
	jc L215
X66:
	.dbline 585
; 		{
; 			pwmGoal[i]=0;
; 		}
; 		
; 		sendAck(slavebuf[2], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 586
; 		return;
	xjmp L122
L212:
	.dbline 589
; 	}
; 	
; 	sendAck(slavebuf[2], EUNKNOWNCMD);
	mov A,3
	push A
	mov REG[0xd0],>_slavebuf
	mov A,[_slavebuf+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 590
; 	return;
	.dbline -2
L122:
	add SP,-7
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l mask 6 c
	.dbsym l err 5 c
	.dbsym l dir 4 c
	.dbsym l len 3 c
	.dbsym l v 2 c
	.dbsym l port 1 c
	.dbsym l i 0 c
	.dbend
	.dbfunc e chksend _chksend fc
;              c -> X-5
;            chk -> X-4
_chksend::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 595
; 
; }
; 
; unsigned char chksend(unsigned char chk, unsigned char c)
; {
	.dbline 596
; 	ED_SLAVE_putData(c);
	push X
	mov A,[X-5]
	xcall _ED_SLAVE_putData
	pop X
	.dbline 597
; 	return (chk<<1)+c+(chk&0x80 ? 1: 0);
	tst [X-4],-128
	jz L223
	mov [X+1],1
	mov [X+0],0
	xjmp L224
L223:
	mov [X+1],0
	mov [X+0],0
L224:
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	asl [__r1]
	mov A,[X-5]
	add [__r1],A
	mov A,[X+1]
	add [__r1],A
	mov A,[__r1]
	.dbline -2
L221:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -5 c
	.dbsym l chk -4 c
	.dbend
	.dbfunc e chksendi _chksendi fc
;              c -> X-6
;            chk -> X-4
_chksendi::
	.dbline -1
	push X
	mov X,SP
	.dbline 601
; }
; 
; unsigned char chksendi(unsigned char chk, unsigned int c)
; {
	.dbline 602
; 	chk = chksend(chk, c>>8);
	mov REG[0xd0],>__r0
	mov A,[X-6]
	push A
	mov A,[X-4]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X-4],A
	.dbline 603
; 	chk = chksend(chk, c&0xff);
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X-4],A
	.dbline 604
; 	return chk;
	mov A,[X-4]
	.dbline -2
L225:
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -6 i
	.dbsym l chk -4 c
	.dbend
	.dbfunc e sendAck _sendAck fV
;            chk -> X+0
;          error -> X-5
;          flags -> X-4
_sendAck::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 609
; }
; 
; // note: convention that error==0 means no error
; void sendAck(unsigned char flags, unsigned char error)
; {
	.dbline 610
; 	unsigned char chk=0;
	mov [X+0],0
	.dbline 612
; 	
; 	chk = chksend(chk, 237);
	mov A,-19
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 613
; 	chk = chksend(chk, 5);
	mov A,5
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 614
; 	chk = chksend(chk, flags);
	mov A,[X-4]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 615
; 	chk = chksend(chk, error);
	mov A,[X-5]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 616
; 	chk = chksend(chk, chk);
	mov A,[X+0]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline -2
	.dbline 617
; }
L226:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chk 0 c
	.dbsym l error -5 c
	.dbsym l flags -4 c
	.dbend
	.dbfunc e sendPacket _sendPacket fV
;             v2 -> X+4
;             v1 -> X+2
;            chk -> X+1
;              i -> X+0
;          flags -> X-4
_sendPacket::
	.dbline -1
	push X
	mov X,SP
	add SP,6
	.dbline 620
; 
; void sendPacket(unsigned char flags)
; {
	.dbline 621
; 	unsigned char chk=0;
	mov [X+1],0
	.dbline 625
; 	unsigned char i;
; 	unsigned int v1, v2;
; 		
; 	chk = chksend(chk, 237);
	mov A,-19
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 626
; 	chk = chksend(chk, 49);
	mov A,49
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 627
; 	chk = chksend(chk, flags);
	mov A,[X-4]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 628
; 	chk = chksend(chk, '*'); // i'm a state packet
	mov A,42
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov [X+1],A
	.dbline 630
; 
; 	M8C_DisableGInt; // atomically sample quad phase data.
		and F, FEh

	.dbline 631
; 	v1=qpdata0;
	mov REG[0xd0],>_qpdata0
	mov A,[_qpdata0+1]
	mov [X+3],A
	mov A,[_qpdata0]
	mov [X+2],A
	.dbline 632
; 	v2=qpdata1;
	mov REG[0xd0],>_qpdata1
	mov A,[_qpdata1+1]
	mov [X+5],A
	mov A,[_qpdata1]
	mov [X+4],A
	.dbline 633
; 	M8C_EnableGInt;
		or  F, 01h

	.dbline 636
; 	
; 	// PIN MODES
; 	for (i=0;i<4;i+=2)
	mov [X+0],0
	xjmp L231
L228:
	.dbline 637
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pinmode+1
	adc [__r0],>_pinmode+1
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	asl A
	asl A
	asl A
	asl A
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_pinmode
	adc [__r2],>_pinmode
	mov A,[__r2]
	mov REG[0xd4],A
	mvi A,[__r3]
	or A,[__r0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
L229:
	.dbline 636
	add [X+0],2
L231:
	.dbline 636
	cmp [X+0],4
	jc L228
X67:
	.dbline 639
; 		chk = chksend(chk, pinmode[i] | (pinmode[i+1]<<4));
; 
; 	chk = chksend(chk, PRT2DR);
	mov A,REG[0x8]
	mov REG[0xd0],>__r0
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 641
; 	
; 	chk = chksendi(chk, v1);
	mov A,[X+2]
	push A
	mov A,[X+3]
	push A
	mov A,[X+1]
	push A
	xcall _chksendi
	mov [X+1],A
	.dbline 642
; 	chk = chksend(chk, qperrs0);
	mov REG[0xd0],>_qperrs0
	mov A,[_qperrs0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-5
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 643
; 	chk = chksendi(chk, v2);
	mov A,[X+4]
	push A
	mov A,[X+5]
	push A
	mov A,[X+1]
	push A
	xcall _chksendi
	mov [X+1],A
	.dbline 644
; 	chk = chksend(chk, qperrs1);
	mov REG[0xd0],>_qperrs1
	mov A,[_qperrs1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-5
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 646
; 
; 	for (i=0;i<4;i++)
	mov [X+0],0
	xjmp L236
L233:
	.dbline 647
	.dbline 648
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmGoal
	adc [__r0],>_pwmGoal
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 649
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmActual
	adc [__r0],>_pwmActual
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 650
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pwmSlew
	adc [__r0],>_pwmSlew
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 651
L234:
	.dbline 646
	inc [X+0]
L236:
	.dbline 646
	cmp [X+0],4
	jc L233
X68:
	.dbline 653
; 	{
; 		chk = chksend(chk, pwmGoal[i]);
; 		chk = chksend(chk, pwmActual[i]);
; 		chk = chksend(chk, pwmSlew[i]);
; 	}
; 	
; 	for (i=0;i<4;i+=2)
	mov [X+0],0
	xjmp L240
L237:
	.dbline 654
	.dbline 655
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_motorDir
	adc [__r0],>_motorDir
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_motorDir+1
	adc [__r2],>_motorDir+1
	mov A,[__r2]
	mov REG[0xd4],A
	mvi A,[__r3]
	asl A
	asl A
	asl A
	asl A
	or A,[__r0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 656
L238:
	.dbline 653
	add [X+0],2
L240:
	.dbline 653
	cmp [X+0],4
	jc L237
X69:
	.dbline 659
; 	{
; 		chk = chksend(chk, (motorDir[i+1]<<4) | motorDir[i]);
; 	}
; 	
; 	// ANALOG
; 	for (i=0;i<8;i++)
	mov [X+0],0
	xjmp L245
L242:
	.dbline 660
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	mov A,[__r1]
	add A,<_analogOffsetError
	mov [__r3],A
	mov A,[__r0]
	adc A,>_analogOffsetError
	mov REG[0xd4],A
	mvi A,[__r3]
	mov [__r2],A
	mvi A,[__r3]
	mov [__r3],A
	add [__r1],<_analog
	adc [__r0],>_analog
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mvi A,[__r1]
	mov [__r1],A
	mov A,[__r3]
	sub [__r1],A
	mov A,[__r2]
	sbb [__r0],A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[X+1]
	push A
	xcall _chksendi
	add SP,-3
	mov REG[0xd0],>__r0
	mov [X+1],A
L243:
	.dbline 659
	inc [X+0]
L245:
	.dbline 659
	cmp [X+0],8
	jc L242
X70:
	.dbline 662
; 		chk = chksendi(chk, analog[i]-analogOffsetError[i]); 
; 
; 	for (i=0;i<8;i+=2)
	mov [X+0],0
	xjmp L249
L246:
	.dbline 663
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_analogFilter
	adc [__r0],>_analogFilter
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mov A,[X+0]
	mov [__r3],A
	mov [__r2],0
	add [__r3],<_analogFilter+1
	adc [__r2],>_analogFilter+1
	mov A,[__r2]
	mov REG[0xd4],A
	mvi A,[__r3]
	asl A
	asl A
	asl A
	asl A
	or A,[__r0]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+1],A
L247:
	.dbline 662
	add [X+0],2
L249:
	.dbline 662
	cmp [X+0],8
	jc L246
X71:
	.dbline 665
; 		chk = chksend(chk, (analogFilter[i+1]<<4) | analogFilter[i]);
; 	
; 	chk = chksend(chk, badchars);
	mov REG[0xd0],>_badchars
	mov A,[_badchars]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 667
; 	
; 	chk = chksend(chk, chk);
	mov A,[X+1]
	push A
	mov A,[X+1]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline -2
	.dbline 668
; }
L227:
	add SP,-6
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v2 4 i
	.dbsym l v1 2 i
	.dbsym l chk 1 c
	.dbsym l i 0 c
	.dbsym l flags -4 c
	.dbend
	.dbfunc e setpinmode _setpinmode fc
;            dm0 -> X+6
;            dm1 -> X+5
;            dm2 -> X+4
;        andmask -> X+3
;         ormask -> X+2
;             gs -> X+1
;           mask -> X+0
;           mode -> X-5
;            pin -> X-4
_setpinmode::
	.dbline -1
	push X
	mov X,SP
	add SP,9
	.dbline 672
; 
; // returns non-zero on error
; unsigned char setpinmode(unsigned char pin, unsigned char mode)
; {
	.dbline 674
; unsigned char mask;
; unsigned char dm2, dm1, dm0, gs=0;
	mov [X+1],0
	.dbline 675
; unsigned char ormask=0, andmask=0xff;
	mov [X+2],0
	.dbline 675
	mov [X+3],-1
	.dbline 709
; 
; // Summary of Tech Ref Manual info:
; // Each pin described by three bits, called DM2, DM1, and DM0.
; // Each bit is stored in a different register.
; //
; // DM: 2 1 0	Pin Output High    Pin Output Low    Notes
; // ----------   ----------------   ----------------  -------------------
; //     0 0 0         Strong           Resistive		 "pull down", set out=1
; //     0 0 1         Strong            Strong        "totem pole"
; //     0 1 0          Hi-Z              Hi-Z         Digital Input Enabled
; //     0 1 1        Resistive          Strong        "pull up", set out=0
; //     1 0 0          Weak              Hi-Z         
; //     1 0 1          Weak              Weak         "weak totem pole"
; //     1 1 0          Hi-Z				Hi-Z         Analog Input
; //     1 1 1          Hi-Z              Weak         I2C-Compat.
; //
; // PRTxGS port connects the pin to its corresponding global bus.
; // If DM210=010, it connects to global input
; // Otherwise, it connects to global output.
; //
; // Note: 
; // If using pull-ups, you MUST write '0's to the corresponding bit whenever
; // you write to PRTxDR. Likewise, when using pull-downs, you MUST write '1's to 
; // the corresponding bit.
; //
; // Here's our general scheme: for a given pin, it can have any of a number of
; // "standard" modes (dig in/out, analog in for some pins). The "special" modes, 
; // such as servo, sonar_echo, are activated by setting the corresponding GS pin.
; // We "preconfigure" all of the special modes so that by setting the GS pin, it 
; // becomes appropriately connected. Note that this means that any given pin can only
; // have a single "special" function.
; 
; // catch illegal arguments 
; if (pin>3)   // illegal pin number
	mov A,3
	cmp A,[X-4]
	jnc L252
X73:
	.dbline 710
; 	return EBADPORT;
	mov REG[0xd0],>__r0
	mov A,1
	xjmp L251
L252:
	.dbline 712
; 
; if (pin>PINMODE_MAX)
	mov A,14
	cmp A,[X-4]
	jnc L254
X74:
	.dbline 713
; 	return EBADPARAM;
	mov REG[0xd0],>__r0
	mov A,2
	xjmp L251
L254:
	.dbline 716
; 
; // Look-up table for our mode pins.
; switch (mode)
	mov A,[X-5]
	mov [X+8],A
	mov [X+7],0
	cmp [X+7],0
	jnz X75
	cmp [X+8],0
	jz L259
X75:
	cmp [X+7],0
	jnz X76
	cmp [X+8],1
	jz L260
X76:
	cmp [X+7],0
	jnz X77
	cmp [X+8],2
	jz L261
X77:
	cmp [X+7],0
	jnz X78
	cmp [X+8],3
	jz L262
X78:
	cmp [X+7],0
	jnz X79
	cmp [X+8],4
	jz L263
X79:
	cmp [X+7],0
	jnz X80
	cmp [X+8],8
	jz L265
X80:
	cmp [X+7],0
	jnz X81
	cmp [X+8],9
	jz L265
X81:
	cmp [X+7],0
	jnz X82
	cmp [X+8],11
	jz L264
X82:
	cmp [X+7],0
	jnz X83
	cmp [X+8],12
	jz L264
X83:
	cmp [X+7],0
	jnz X84
	cmp [X+8],14
	jz L266
X84:
	xjmp L256
X72:
	.dbline 717
; 	{
L259:
	.dbline 719
; 	case PINMODE_DIG_IN:
; 		dm2=0x00; dm1=0xff; dm0=0x00;
	mov [X+4],0
	.dbline 719
	mov [X+5],-1
	.dbline 719
	mov [X+6],0
	.dbline 720
; 		break;
	xjmp L257
L260:
	.dbline 723
; 	
; 	case PINMODE_DIG_IN_PULLUP:
; 		dm2=0x00; dm1=0xff; dm0=0xff;
	mov [X+4],0
	.dbline 723
	mov [X+5],-1
	.dbline 723
	mov [X+6],-1
	.dbline 724
; 		ormask=0xff;
	mov [X+2],-1
	.dbline 725
; 		break;
	xjmp L257
L261:
	.dbline 728
; 
; 	case PINMODE_DIG_IN_PULLDN:
; 		dm2=0x00; dm1=0x00; dm0=0x00;
	mov [X+4],0
	.dbline 728
	mov [X+5],0
	.dbline 728
	mov [X+6],0
	.dbline 729
; 		andmask=0x00;
	mov [X+3],0
	.dbline 730
; 		break;
	xjmp L257
L262:
	.dbline 733
; 
; 	case PINMODE_DIG_OUT_STRONG:
; 		dm2=0x00; dm1=0x00; dm0=0xff;
	mov [X+4],0
	.dbline 733
	mov [X+5],0
	.dbline 733
	mov [X+6],-1
	.dbline 734
; 		break;
	xjmp L257
L263:
	.dbline 737
; 		
; 	case PINMODE_DIG_OUT_SLOW:
; 		dm2=0xff; dm1=0x00; dm0=0xff;
	mov [X+4],-1
	.dbline 737
	mov [X+5],0
	.dbline 737
	mov [X+6],-1
	.dbline 738
; 		break;
	xjmp L257
L264:
	.dbline 742
; 		
; 	case PINMODE_MONOPHASE:
; 	case PINMODE_QUADPHASE:
; 		dm2=0x00; dm1=0xff; dm0=0x00; gs=0x00;
	mov [X+4],0
	.dbline 742
	mov [X+5],-1
	.dbline 742
	mov [X+6],0
	.dbline 742
	mov [X+1],0
	.dbline 743
; 		ormask=0xff;
	mov [X+2],-1
	.dbline 744
; 		break;	
	xjmp L257
L265:
	.dbline 748
; 	
; 	case PINMODE_ANALOG_OUT:
; 	case PINMODE_ANALOG_IN:
; 		dm2=0xff; dm1=0xff; dm0=0x00;
	mov [X+4],-1
	.dbline 748
	mov [X+5],-1
	.dbline 748
	mov [X+6],0
	.dbline 749
; 		break;	
	xjmp L257
L266:
	.dbline 752
; 
; 	case PINMODE_QUADPHASEFAST:
; 		dm2=0x00; dm1=0xff; dm0=0x00; gs=0xff;
	mov [X+4],0
	.dbline 752
	mov [X+5],-1
	.dbline 752
	mov [X+6],0
	.dbline 752
	mov [X+1],-1
	.dbline 753
; 		break;	
	xjmp L257
L256:
	.dbline 756
; 
; 	default:
; 		return EBADPARAM; // unknown pin type
	mov REG[0xd0],>__r0
	mov A,2
	xjmp L251
L257:
	.dbline 759
; 	}
; 
; 	mask=1<<pin;
	mov REG[0xd0],>__r0
	mov [__r0],1
	mov A,[X-4]
	and A,7
	jz X85
X86:
	mov REG[0xd0],>__r0
	asl [__r0]
	dec A
	jnz X86
X85:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov [X+0],A
	.dbline 760
; 	PRT2DM2=(PRT2DM2&(~mask)) | (dm2&mask);
	mov A,[X+4]
	and A,[X+0]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	mov [__r2],A
	mov A,REG[0xb]
	and A,[__r2]
	or A,[__r0]
	mov REG[0xb],A
	.dbline 761
; 	PRT2DM1=(PRT2DM1&(~mask)) | (dm1&mask);
	mov A,[X+5]
	and A,[X+0]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	mov [__r2],A
	or F,0x10  ; iopage = 1
	mov A,REG[0x9]
	and A,[__r2]
	or A,[__r0]
	mov REG[0x9],A
	.dbline 762
; 	PRT2DM0=(PRT2DM0&(~mask)) | (dm0&mask);
	mov A,[X+6]
	and A,[X+0]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	mov [__r2],A
	mov A,REG[0x8]
	and A,[__r2]
	or A,[__r0]
	mov REG[0x8],A
	and F,0xEF ; iopage = 0
	.dbline 763
; 	PRT2GS =(PRT2GS&(~mask))  | (gs&mask);
	mov A,[X+1]
	and A,[X+0]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	mov [__r2],A
	mov A,REG[0xa]
	and A,[__r2]
	or A,[__r0]
	mov REG[0xa],A
	.dbline 764
; 	prt2andmask = (prt2andmask&(~mask)) | (andmask&mask);
	mov A,[X+3]
	and A,[X+0]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	mov [__r2],A
	mov REG[0xd0],>_prt2andmask
	mov A,[_prt2andmask]
	mov REG[0xd0],>__r0
	and A,[__r2]
	or A,[__r0]
	mov REG[0xd0],>_prt2andmask
	mov [_prt2andmask],A
	.dbline 765
; 	prt2ormask  = (prt2ormask&(~mask))  | (ormask&mask);
	mov REG[0xd0],>__r0
	mov A,[X+2]
	and A,[X+0]
	mov [__r0],A
	mov A,[X+0]
	cpl A
	mov [__r2],A
	mov REG[0xd0],>_prt2ormask
	mov A,[_prt2ormask]
	mov REG[0xd0],>__r0
	and A,[__r2]
	or A,[__r0]
	mov REG[0xd0],>_prt2ormask
	mov [_prt2ormask],A
	.dbline 767
; 	
; 	PRT2DR=(PRT2DR&prt2andmask) | prt2ormask;
	mov A,REG[0x8]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov REG[0xd0],>_prt2andmask
	mov A,[_prt2andmask]
	mov REG[0xd0],>__r0
	and [__r0],A
	mov REG[0xd0],>_prt2ormask
	mov A,[_prt2ormask]
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[__r0]
	mov REG[0x8],A
	.dbline 769
; 
; 	pinmode[pin]=mode;
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_pinmode
	adc [__r0],>_pinmode
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X-5]
	mvi [__r1],A
	.dbline 771
; 
; 	return ESUCCESS;
	mov A,0
	.dbline -2
L251:
	add SP,-9
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l dm0 6 c
	.dbsym l dm1 5 c
	.dbsym l dm2 4 c
	.dbsym l andmask 3 c
	.dbsym l ormask 2 c
	.dbsym l gs 1 c
	.dbsym l mask 0 c
	.dbsym l mode -5 c
	.dbsym l pin -4 c
	.dbend
	.dbfunc e updateQp _updateQp fV
;        newDown -> X+6
;          newUp -> X+4
;      deltaDown -> X+2
;        deltaUp -> X+0
_updateQp::
	.dbline -1
	push X
	mov X,SP
	add SP,8
	.dbline 778
; }
; 
; unsigned char qp0LastUp, qp0LastDown;
; unsigned char qp1LastUp, qp1LastDown;
; 
; void updateQp(void)
; {
	.dbline 782
; 	int newUp, newDown;
; 	int deltaUp, deltaDown;
; 	
; 	newUp=255-QP0A_readDirect();
	push X
	xcall _QP0A_readDirect
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	mov [__r0],0
	mov A,-1
	sub A,[__r1]
	mov [X+5],A
	mov A,0
	sbb A,[__r0]
	mov [X+4],A
	.dbline 783
; 	newDown=255-QP0B_readDirect();
	push X
	xcall _QP0B_readDirect
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	mov [__r0],0
	mov A,-1
	sub A,[__r1]
	mov [X+7],A
	mov A,0
	sbb A,[__r0]
	mov [X+6],A
	.dbline 785
; 	
; 	deltaUp=newUp-qp0LastUp;
	mov REG[0xd0],>_qp0LastUp
	mov A,[_qp0LastUp]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov A,[X+5]
	sub A,[__r1]
	mov [X+1],A
	mov A,[X+4]
	sbb A,[__r0]
	mov [X+0],A
	.dbline 786
; 	if (deltaUp<0)
	mov A,[X+1]
	sub A,0
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jnc L268
X87:
	.dbline 787
; 		deltaUp+=256;
	add [X+1],0
	adc [X+0],1
L268:
	.dbline 789
; 	
; 	deltaDown=newDown-qp0LastDown;
	mov REG[0xd0],>_qp0LastDown
	mov A,[_qp0LastDown]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	mov A,[X+7]
	sub A,[__r1]
	mov [X+3],A
	mov A,[X+6]
	sbb A,[__r0]
	mov [X+2],A
	.dbline 790
; 	if (deltaDown<0)
	mov A,[X+3]
	sub A,0
	mov A,[X+2]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jnc L270
X88:
	.dbline 791
; 		deltaDown+=256;
	add [X+3],0
	adc [X+2],1
L270:
	.dbline 793
; 	
; 	qpdata0+=(deltaUp-deltaDown);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	sub A,[X+3]
	mov [__r1],A
	mov A,[X+0]
	sbb A,[X+2]
	mov [__r0],A
	mov A,[__r1]
	mov REG[0xd0],>_qpdata0
	add [_qpdata0+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov REG[0xd0],>_qpdata0
	adc [_qpdata0],A
	.dbline 794
; 	qp0LastUp=newUp;
	mov A,[X+5]
	mov REG[0xd0],>_qp0LastUp
	mov [_qp0LastUp],A
	.dbline 795
; 	qp0LastDown=newDown;
	mov A,[X+7]
	mov REG[0xd0],>_qp0LastDown
	mov [_qp0LastDown],A
	.dbline 799
; 	
; 	////// same thing for channel 1
; 
; 	newUp=255-QP1A_readDirect();
	push X
	xcall _QP1A_readDirect
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	mov [__r0],0
	mov A,-1
	sub A,[__r1]
	mov [X+5],A
	mov A,0
	sbb A,[__r0]
	mov [X+4],A
	.dbline 800
; 	newDown=255-QP1B_readDirect();
	push X
	xcall _QP1B_readDirect
	mov REG[0xd0],>__r0
	pop X
	mov [__r1],A
	mov [__r0],0
	mov A,-1
	sub A,[__r1]
	mov [X+7],A
	mov A,0
	sbb A,[__r0]
	mov [X+6],A
	.dbline 802
; 	
; 	deltaUp=newUp-qp1LastUp;
	mov REG[0xd0],>_qp1LastUp
	mov A,[_qp1LastUp]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov A,[X+5]
	sub A,[__r1]
	mov [X+1],A
	mov A,[X+4]
	sbb A,[__r0]
	mov [X+0],A
	.dbline 803
; 	if (deltaUp<0)
	mov A,[X+1]
	sub A,0
	mov A,[X+0]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jnc L272
X89:
	.dbline 804
; 		deltaUp+=256;
	add [X+1],0
	adc [X+0],1
L272:
	.dbline 806
; 	
; 	deltaDown=newDown-qp1LastDown;
	mov REG[0xd0],>_qp1LastDown
	mov A,[_qp1LastDown]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	mov A,[X+7]
	sub A,[__r1]
	mov [X+3],A
	mov A,[X+6]
	sbb A,[__r0]
	mov [X+2],A
	.dbline 807
; 	if (deltaDown<0)
	mov A,[X+3]
	sub A,0
	mov A,[X+2]
	xor A,-128
	sbb A,(0 ^ 0x80)
	jnc L274
X90:
	.dbline 808
; 		deltaDown+=256;
	add [X+3],0
	adc [X+2],1
L274:
	.dbline 810
; 	
; 	qpdata1+=(deltaUp-deltaDown);
	mov REG[0xd0],>__r0
	mov A,[X+1]
	sub A,[X+3]
	mov [__r1],A
	mov A,[X+0]
	sbb A,[X+2]
	mov [__r0],A
	mov A,[__r1]
	mov REG[0xd0],>_qpdata1
	add [_qpdata1+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov REG[0xd0],>_qpdata1
	adc [_qpdata1],A
	.dbline 811
; 	qp1LastUp=newUp;
	mov A,[X+5]
	mov REG[0xd0],>_qp1LastUp
	mov [_qp1LastUp],A
	.dbline 812
; 	qp1LastDown=newDown;
	mov A,[X+7]
	mov REG[0xd0],>_qp1LastDown
	mov [_qp1LastDown],A
	.dbline -2
	.dbline 814
; 
; }
L267:
	add SP,-8
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l newDown 6 I
	.dbsym l newUp 4 I
	.dbsym l deltaDown 2 I
	.dbsym l deltaUp 0 I
	.dbend
	.area data(ram, con, rel)
	.dbfile ./main.c
_qp1LastDown::
	.byte 0
	.dbsym e qp1LastDown _qp1LastDown c
	.area data(ram, con, rel)
	.dbfile ./main.c
_qp1LastUp::
	.byte 0
	.dbsym e qp1LastUp _qp1LastUp c
	.area data(ram, con, rel)
	.dbfile ./main.c
_qp0LastDown::
	.byte 0
	.dbsym e qp0LastDown _qp0LastDown c
	.area data(ram, con, rel)
	.dbfile ./main.c
_qp0LastUp::
	.byte 0
	.dbsym e qp0LastUp _qp0LastUp c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pinmode::
	.byte 0,0,0,0,0,0,0,0
	.dbsym e pinmode _pinmode A[8:8]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_lastcounter::
	.byte 0,0,0,0
	.dbsym e lastcounter _lastcounter L
	.area data(ram, con, rel)
	.dbfile ./main.c
_slavebuf::
	.word 0,0,0,0,0
	.word 0,0,0,0,0
	.word 0,0,0,0,0
	.byte 0,0
	.dbsym e slavebuf _slavebuf A[32:32]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_motorDir::
	.byte 0,0,0,0
	.dbsym e motorDir _motorDir A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pwmSlew::
	.byte 0,0,0,0
	.dbsym e pwmSlew _pwmSlew A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pwmActual::
	.byte 0,0,0,0
	.dbsym e pwmActual _pwmActual A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_pwmGoal::
	.byte 0,0,0,0
	.dbsym e pwmGoal _pwmGoal A[4:4]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogResolution::
	.byte 0,0
	.dbsym e analogResolution _analogResolution S
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogDelay::
	.byte 0,0
	.dbsym e analogDelay _analogDelay S
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogNext::
	.byte 0,0
	.dbsym e analogNext _analogNext S
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogFilter::
	.byte 0,0,0,0,0,0,0,0
	.dbsym e analogFilter _analogFilter A[8:8]c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogOffsetError::
	.word 0,0,0,0,0
	.byte 0,0
	.dbsym e analogOffsetError _analogOffsetError A[12:6]i
	.area data(ram, con, rel)
	.dbfile ./main.c
_analog::
	.word 0,0,0,0,0
	.byte 0,0,0,0,0,0
	.dbsym e analog _analog A[16:8]i
